<?php
/**
 * Plugin Name: WooTsap - WhatsApp for WooCommerce
 * Plugin URI: https://wootsap.com
 * Description: Send WooCommerce order notifications to customers via WhatsApp
 * Version: 1.0.0
 * Author: WooTsap
 * Author URI: https://wootsap.com
 * Text Domain: wootsap
 * Requires at least: 5.6
 * Requires PHP: 7.2
 * WC requires at least: 5.0
 * WC tested up to: 8.0
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Check if WooCommerce is active
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
    add_action('admin_notices', function() {
        echo '<div class="error"><p>' . __('WooTsap requires WooCommerce to be installed and active.', 'wootsap') . '</p></div>';
    });
    return;
}

// Declare HPOS compatibility
add_action('before_woocommerce_init', function() {
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

// Define plugin constants
define('WOOTSAP_VERSION', '1.0.0');
define('WOOTSAP_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WOOTSAP_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WOOTSAP_PLUGIN_FILE', __FILE__);

// Include required files
require_once WOOTSAP_PLUGIN_DIR . 'includes/class-wootsap.php';

// Initialize plugin
function wootsap_init() {
    $plugin = new WooTsap();
    $plugin->init();
}
add_action('plugins_loaded', 'wootsap_init');

// Add plugin action links
function wootsap_plugin_action_links($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=wootsap-settings') . '">' . __('Settings', 'wootsap') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wootsap_plugin_action_links');