<?php
/**
 * Settings page template
 */

// If accessed directly, exit
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <div class="wootsap-header" style="margin-bottom: 20px;">
        <div style="font-size: 28px; font-weight: bold; color: #25a820; margin-bottom: 5px;">
            WooTsap <span style="font-size: 16px; font-weight: normal; color: #25a820;">powered by WooSMS</span>
        </div>
        <h1>WooTsap Settings</h1>
    </div>
    
    <?php if (isset($_GET['settings-updated'])) : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php echo esc_html__('Settings saved successfully!', 'wootsap'); ?></p>
        </div>
    <?php endif; ?>
    
    <!-- Debug Information -->
    <?php if (get_option('wootsap_debug_mode') == '1') : ?>
    <div class="notice notice-info" style="border-left-color: #00a0d2;">
        <p><strong><?php echo esc_html__('Debug Information', 'wootsap'); ?></strong></p>
        <p><?php echo esc_html__('If you are experiencing issues, please check the debug information below:', 'wootsap'); ?></p>
        <ul>
            <li><?php echo esc_html__('WooCommerce Version:', 'wootsap'); ?> <?php echo WC()->version; ?></li>
            <li><?php echo esc_html__('WordPress Version:', 'wootsap'); ?> <?php echo get_bloginfo('version'); ?></li>
            <li><?php echo esc_html__('PHP Version:', 'wootsap'); ?> <?php echo phpversion(); ?></li>
            <li><?php echo esc_html__('API Token Set:', 'wootsap'); ?> <?php echo !empty(get_option('wootsap_api_token')) ? '✅' : '❌'; ?></li>
            <li><?php echo esc_html__('Instance ID Set:', 'wootsap'); ?> <?php echo !empty(get_option('wootsap_instance_id')) ? '✅' : '❌'; ?></li>
            <li><?php echo esc_html__('Processing Notifications:', 'wootsap'); ?> <?php echo get_option('wootsap_enable_processing') == '1' ? '✅ Enabled' : '❌ Disabled'; ?></li>
            <li><?php echo esc_html__('Completed Notifications:', 'wootsap'); ?> <?php echo get_option('wootsap_enable_completed') == '1' ? '✅ Enabled' : '❌ Disabled'; ?></li>
            <li><?php echo esc_html__('Debug Mode:', 'wootsap'); ?> <?php echo get_option('wootsap_debug_mode') == '1' ? '✅ Enabled' : '❌ Disabled'; ?></li>
        </ul>
        <p><?php echo esc_html__('For more detailed information, check your WordPress debug.log file.', 'wootsap'); ?></p>
    </div>
    <?php endif; ?>

    <form method="post" action="options.php">
        <?php
        settings_fields('wootsap_settings');
        do_settings_sections('wootsap_settings');
        ?>
        
        <div class="wootsap-settings-tabs">
            <h2 class="nav-tab-wrapper">
                <a href="#api-settings" class="nav-tab nav-tab-active">API Settings</a>
                <a href="#notification-settings" class="nav-tab">Notification Settings</a>
                <a href="#advanced-settings" class="nav-tab">Advanced</a>
            </h2>
            
            <div class="wootsap-tab-content" id="api-settings" style="display: block;">
                <h2><?php echo esc_html__('API Configuration', 'wootsap'); ?></h2>
                <p><?php echo esc_html__('Enter your WooTsap API credentials below:', 'wootsap'); ?></p>
                
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('API Token', 'wootsap'); ?></th>
                        <td>
                            <input type="text" name="wootsap_api_token" value="<?php echo esc_attr(get_option('wootsap_api_token')); ?>" class="regular-text" />
                            <p class="description"><?php echo esc_html__('Your WooTsap API token', 'wootsap'); ?></p>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('Instance ID', 'wootsap'); ?></th>
                        <td>
                            <input type="text" name="wootsap_instance_id" value="<?php echo esc_attr(get_option('wootsap_instance_id')); ?>" class="regular-text" />
                            <p class="description"><?php echo esc_html__('Your WooTsap WhatsApp instance ID', 'wootsap'); ?></p>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('Test Connection', 'wootsap'); ?></th>
                        <td>
                            <div style="display: flex; align-items: flex-start; margin-bottom: 10px;">
                                <input type="text" id="wootsap_test_phone" name="wootsap_test_phone" class="regular-text" 
                                    placeholder="<?php echo esc_attr__('Enter WhatsApp number for testing (with country code)', 'wootsap'); ?>" style="margin-right: 10px;" />
                                
                                <button type="button" id="wootsap_test_api_btn" class="button button-secondary">
                                    <?php echo esc_html__('Test Connection', 'wootsap'); ?>
                                </button>
                                
                                <span class="spinner" style="float: none; margin-left: 5px;"></span>
                            </div>
                            
                            <div id="wootsap_test_result" style="margin-top: 10px;"></div>
                            
                            <p class="description">
                                <?php echo esc_html__('Enter a WhatsApp number to test your API connection. The number should include country code (e.g., 911234567890).', 'wootsap'); ?>
                            </p>
                            
                            <input type="hidden" id="wootsap_ajax_nonce" value="<?php echo wp_create_nonce('wootsap-admin'); ?>" />
                        </td>
                    </tr>
                </table>
            </div>
            
            <div class="wootsap-tab-content" id="notification-settings" style="display: none;">
                <h2><?php echo esc_html__('Notification Settings', 'wootsap'); ?></h2>
                
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('Phone Number Settings', 'wootsap'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="wootsap_add_country_code" value="1" <?php checked(1, get_option('wootsap_add_country_code'), true); ?> />
                                <?php echo esc_html__('Automatically add country code to phone numbers', 'wootsap'); ?>
                            </label>
                        </td>
                    </tr>
                    
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('Default Country Code', 'wootsap'); ?></th>
                        <td>
                            <input type="text" name="wootsap_default_country_code" value="<?php echo esc_attr(get_option('wootsap_default_country_code', '91')); ?>" class="small-text" />
                            <span class="description"><?php echo esc_html__('Without + sign (e.g., 91 for India)', 'wootsap'); ?></span>
                        </td>
                    </tr>
                </table>
                
                <?php
                // Get all WooCommerce order statuses
                $order_statuses = wc_get_order_statuses();
                
                // Remove wc- prefix from status keys
                $formatted_statuses = array();
                foreach ($order_statuses as $status_key => $status_label) {
                    $key = str_replace('wc-', '', $status_key);
                    $formatted_statuses[$key] = $status_label;
                }
                
                // Loop through each status to create settings
                foreach ($formatted_statuses as $status => $label) :
                    $status_option_key = 'wootsap_enable_' . $status;
                    $message_option_key = 'wootsap_' . $status . '_message';
                    
                    // Get default message based on status
                    $default_message = '';
                    switch ($status) {
                        case 'processing':
                            $default_message = 'Hello {customer_name}, your order #{order_number} has been received and is being processed. Total: {order_total}. Thank you for shopping with us!';
                            break;
                        case 'completed':
                            $default_message = 'Great news {customer_name}! Your order #{order_number} has been completed and is on its way to you. Thank you for shopping with us!';
                            break;
                        case 'on-hold':
                            $default_message = 'Hello {customer_name}, your order #{order_number} has been placed on hold. Total: {order_total}. We\'ll notify you when it\'s processing again.';
                            break;
                        case 'cancelled':
                            $default_message = 'Hello {customer_name}, your order #{order_number} has been cancelled. If you have any questions, please contact us.';
                            break;
                        case 'refunded':
                            $default_message = 'Hello {customer_name}, your order #{order_number} has been refunded. The amount of {order_total} will be returned to your payment method.';
                            break;
                        case 'failed':
                            $default_message = 'Hello {customer_name}, unfortunately your order #{order_number} has failed. Please try again or contact us for assistance.';
                            break;
                        case 'pending':
                            $default_message = 'Hello {customer_name}, your order #{order_number} is pending payment. Total: {order_total}. Please complete the payment to process your order.';
                            break;
                        default:
                            $default_message = 'Hello {customer_name}, the status of your order #{order_number} has been updated to ' . $label . '. Total: {order_total}.';
                            break;
                    }
                ?>
                    <div style="border-top: 1px solid #ddd; margin-top: 20px; padding-top: 10px;">
                        <h3><?php echo esc_html($label); ?> <?php echo esc_html__('Notification', 'wootsap'); ?></h3>
                        
                        <table class="form-table">
                            <tr valign="top">
                                <th scope="row"><?php echo esc_html__('Enable', 'wootsap'); ?></th>
                                <td>
                                    <label>
                                        <input type="checkbox" name="<?php echo esc_attr($status_option_key); ?>" value="1" <?php checked(1, get_option($status_option_key, '0'), true); ?> />
                                        <?php echo sprintf(esc_html__('Send notification when order status changes to %s', 'wootsap'), $label); ?>
                                    </label>
                                </td>
                            </tr>
                            
                            <tr valign="top">
                                <th scope="row"><?php echo esc_html__('Message', 'wootsap'); ?></th>
                                <td>
                                    <textarea name="<?php echo esc_attr($message_option_key); ?>" rows="4" cols="50" class="large-text"><?php echo esc_textarea(get_option($message_option_key, $default_message)); ?></textarea>
                                    
                                    <p class="description" style="margin-bottom: 8px;">
                                        <?php echo esc_html__('Available variables:', 'wootsap'); ?> 
                                        <code>{customer_name}</code>, 
                                        <code>{order_number}</code>, 
                                        <code>{order_total}</code>, 
                                        <code>{order_status}</code>, 
                                        <code>{site_name}</code>
                                    </p>
                                    
                                    <!-- Message Preview -->
                                    <div style="background-color: #f8fcff; padding: 15px; border-radius: 5px; margin: 10px 0; border-left: 4px solid #00a0d2;">
                                        <strong><?php echo esc_html__('Message Preview', 'wootsap'); ?></strong><br>
                                        <?php 
                                        $preview_message = get_option($message_option_key, $default_message);
                                        $preview_message = str_replace(
                                            array('{customer_name}', '{order_number}', '{order_total}', '{order_status}', '{site_name}'),
                                            array('John', '123', '$50.00', $label, get_bloginfo('name')),
                                            $preview_message
                                        );
                                        echo esc_html($preview_message); 
                                        ?>
                                    </div>
                                    
                                    <p class="description" style="color: #d63638;">
                                        <?php echo esc_html__('Note: Do not use HTML tags in your message as they will show as plain text in WhatsApp.', 'wootsap'); ?>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                <?php endforeach; ?>
            </div>
            
            <div class="wootsap-tab-content" id="advanced-settings" style="display: none;">
                <h2><?php echo esc_html__('Advanced Settings', 'wootsap'); ?></h2>
                
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row"><?php echo esc_html__('Debug Mode', 'wootsap'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="wootsap_debug_mode" value="1" <?php checked(1, get_option('wootsap_debug_mode'), true); ?> />
                                <?php echo esc_html__('Enable debug logging', 'wootsap'); ?>
                            </label>
                            <p class="description"><?php echo esc_html__('This will log detailed information to the WordPress debug.log file.', 'wootsap'); ?></p>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <?php submit_button(); ?>
    </form>
</div>

<script>
jQuery(document).ready(function($) {
    // Tab navigation
    $('.nav-tab').on('click', function(e) {
        e.preventDefault();
        
        // Get target tab ID
        var targetTab = $(this).attr('href');
        
        // Update active tab
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        // Show target content
        $('.wootsap-tab-content').hide();
        $(targetTab).show();
    });
    
    // Test API button handler
    $('#wootsap_test_api_btn').on('click', function() {
        var button = $(this);
        var testPhone = $('#wootsap_test_phone').val();
        var resultDiv = $('#wootsap_test_result');
        var spinner = button.next('.spinner');
        var nonce = $('#wootsap_ajax_nonce').val();
        
        // Validate phone
        if (!testPhone || testPhone.trim() === '') {
            resultDiv.html('<span style="color: #d63638;">❌ Please enter a phone number for testing.</span>');
            return;
        }
        
        // Disable button and show spinner
        button.prop('disabled', true);
        spinner.css('visibility', 'visible');
        resultDiv.html('<span>Testing connection...</span>');
        
        // Send AJAX request
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wootsap_test_api',
                security: nonce,
                test_phone: testPhone
            },
            success: function(response) {
                if (response.success) {
                    resultDiv.html('<span style="color: #46b450;">✅ ' + response.data + '</span>');
                } else {
                    resultDiv.html('<span style="color: #d63638;">❌ ' + response.data + '</span>');
                }
            },
            error: function(xhr, status, error) {
                resultDiv.html('<span style="color: #d63638;">❌ Connection error: ' + error + '</span>');
                console.error('AJAX Error:', xhr.responseText);
            },
            complete: function() {
                button.prop('disabled', false);
                spinner.css('visibility', 'hidden');
            }
        });
    });
});
</script>