<?php
/**
 * Order meta box template
 */
// If accessed directly, exit
if (!defined('ABSPATH')) {
    exit;
}
$order_id = $post->ID;
$order = wc_get_order($order_id);
if (!$order) {
    echo '<p>' . __('Error: Order not found', 'wootsap') . '</p>';
    return;
}
// Get WhatsApp number - HPOS compatible
$whatsapp_number = $order->get_meta('_billing_whatsapp', true);
// If no WhatsApp number provided, use billing phone
if (empty($whatsapp_number)) {
    $whatsapp_number = $order->get_billing_phone();
}
// Format phone number
$formatted_number = $this->format_phone_number($whatsapp_number);
// Check if WhatsApp notification is enabled for this order - HPOS compatible
$whatsapp_notification = $order->get_meta('_whatsapp_notification', true);

// Get all WooCommerce order statuses
$order_statuses = wc_get_order_statuses();
?>
<div class="wootsap-metabox">
    <!-- Display status -->
    <p><strong><?php echo __('Status:', 'wootsap'); ?></strong> 
        <?php if ($whatsapp_notification == 'no'): ?>
            <span class="wootsap-status-disabled"><?php echo __('Disabled by customer', 'wootsap'); ?></span>
        <?php else: ?>
            <span class="wootsap-status-enabled"><?php echo __('Enabled', 'wootsap'); ?></span>
        <?php endif; ?>
    </p>
    
    <!-- Display phone number -->
    <p><strong><?php echo __('Phone Number:', 'wootsap'); ?></strong> 
        <?php if (!empty($formatted_number)): ?>
            <?php echo esc_html($formatted_number); ?>
        <?php else: ?>
            <span class="wootsap-status-disabled"><?php echo __('Not available', 'wootsap'); ?></span>
        <?php endif; ?>
    </p>
    
    <!-- Manual send buttons -->
    <?php if (!empty($formatted_number) && $whatsapp_notification != 'no'): ?>
        <?php wp_nonce_field('wootsap-admin', 'wootsap_manual_nonce'); ?>
        <input type="hidden" id="wootsap-order-id" value="<?php echo esc_attr($order_id); ?>">
        
        <p><strong><?php echo __('Send Manual Notification:', 'wootsap'); ?></strong></p>
        
        <div class="wootsap-manual-buttons">
            <?php foreach ($order_statuses as $status_key => $status_label): 
                $status = str_replace('wc-', '', $status_key);
                
                // Check if this status is enabled in settings
                $enable_option = 'wootsap_enable_' . $status;
                $is_enabled = get_option($enable_option) == '1';
                
                // Special handling for legacy options
                if ($status == 'processing') {
                    $is_enabled = $is_enabled || get_option('wootsap_enable_processing') == '1';
                } else if ($status == 'completed') {
                    $is_enabled = $is_enabled || get_option('wootsap_enable_completed') == '1';
                }
                
                // Only show enabled status buttons
                if ($is_enabled):
            ?>
                <button type="button" class="button wootsap-send-manual" data-type="<?php echo esc_attr($status); ?>" style="margin-right: 5px; margin-bottom: 5px;">
                    <?php echo __('Send', 'wootsap'); ?> <?php echo esc_html($status_label); ?>
                </button>
            <?php 
                endif;
            endforeach; 
            ?>
        </div>
        
        <div id="wootsap-manual-result" class="wootsap-result" style="margin-top: 10px;"></div>
    <?php else: ?>
        <p><em><?php echo __('Manual notification sending is not available for this order.', 'wootsap'); ?></em></p>
    <?php endif; ?>
</div>