<?php
/**
 * Documentation page template
 */

// If accessed directly, exit
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap wootsap-documentation">
    <div class="wootsap-header">
        <div class="wootsap-text-logo">
            <span class="wootsap-logo-text">WooTsap</span>
            <span class="wootsap-logo-tagline">powered by WooSMS</span>
        </div>
        <h1><?php echo esc_html__('WooTsap Documentation', 'wootsap'); ?></h1>
    </div>
    
    <div class="wootsap-docs-container">
        <div class="wootsap-docs-sidebar">
            <ul>
                <li><a href="#getting-started"><?php echo esc_html__('Getting Started', 'wootsap'); ?></a></li>
                <li><a href="#installation"><?php echo esc_html__('Installation', 'wootsap'); ?></a></li>
                <li><a href="#configuration"><?php echo esc_html__('Configuration', 'wootsap'); ?></a></li>
                <li><a href="#message-variables"><?php echo esc_html__('Message Variables', 'wootsap'); ?></a></li>
                <li><a href="#troubleshooting"><?php echo esc_html__('Troubleshooting', 'wootsap'); ?></a></li>
                <li><a href="#faq"><?php echo esc_html__('FAQ', 'wootsap'); ?></a></li>
            </ul>
        </div>
        
        <div class="wootsap-docs-content">
            <section id="getting-started">
                <h2><?php echo esc_html__('Getting Started', 'wootsap'); ?></h2>
                <p><?php echo esc_html__('WooTsap allows you to send order notifications to your customers via WhatsApp. This documentation will guide you through setting up and using the plugin.', 'wootsap'); ?></p>
                <p><?php echo esc_html__('To get started, you need:', 'wootsap'); ?></p>
                <ul>
                    <li><?php echo esc_html__('A working WordPress site with WooCommerce installed', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('A WooTsap account with API credentials', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('A connected WhatsApp number (business account recommended)', 'wootsap'); ?></li>
                </ul>
            </section>
            
            <section id="installation">
                <h2><?php echo esc_html__('Installation', 'wootsap'); ?></h2>
                <ol>
                    <li><?php echo esc_html__('Download the WooTsap plugin ZIP file from your account', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('In your WordPress admin, go to Plugins > Add New > Upload Plugin', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Choose the ZIP file and click "Install Now"', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Activate the plugin', 'wootsap'); ?></li>
                </ol>
            </section>
            
            <section id="configuration">
                <h2><?php echo esc_html__('Configuration', 'wootsap'); ?></h2>
                <h3><?php echo esc_html__('API Settings', 'wootsap'); ?></h3>
                <ol>
                    <li><?php echo esc_html__('Go to WooTsap > Settings', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Enter your API Token and Instance ID from your WooTsap account', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Click "Test API Connection" to verify your credentials', 'wootsap'); ?></li>
                </ol>
                
                <h3><?php echo esc_html__('Notification Settings', 'wootsap'); ?></h3>
                <ol>
                    <li><?php echo esc_html__('Configure your phone number settings', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Enable the order status notifications you want to send', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Customize the message templates using the available variables', 'wootsap'); ?></li>
                </ol>
            </section>
            
            <section id="message-variables">
                <h2><?php echo esc_html__('Message Variables', 'wootsap'); ?></h2>
                <p><?php echo esc_html__('You can use the following variables in your notification messages:', 'wootsap'); ?></p>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php echo esc_html__('Variable', 'wootsap'); ?></th>
                            <th><?php echo esc_html__('Description', 'wootsap'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><code>{customer_name}</code></td>
                            <td><?php echo esc_html__('Customer\'s first name', 'wootsap'); ?></td>
                        </tr>
                        <tr>
                            <td><code>{order_number}</code></td>
                            <td><?php echo esc_html__('Order number', 'wootsap'); ?></td>
                        </tr>
                        <tr>
                            <td><code>{order_total}</code></td>
                            <td><?php echo esc_html__('Formatted order total', 'wootsap'); ?></td>
                        </tr>
                        <tr>
                            <td><code>{order_status}</code></td>
                            <td><?php echo esc_html__('Current order status', 'wootsap'); ?></td>
                        </tr>
                        <tr>
                            <td><code>{site_name}</code></td>
                            <td><?php echo esc_html__('Your website name', 'wootsap'); ?></td>
                        </tr>
                    </tbody>
                </table>
            </section>
            
            <section id="troubleshooting">
                <h2><?php echo esc_html__('Troubleshooting', 'wootsap'); ?></h2>
                <h3><?php echo esc_html__('API Connection Issues', 'wootsap'); ?></h3>
                <ul>
                    <li><?php echo esc_html__('Verify your API credentials are correct', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Make sure your WhatsApp instance is connected and available', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Check if your server can connect to the WooTsap API', 'wootsap'); ?></li>
                </ul>
                
                <h3><?php echo esc_html__('Notification Not Sending', 'wootsap'); ?></h3>
                <ul>
                    <li><?php echo esc_html__('Check if the notification is enabled in settings', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Verify the customer has a valid phone number', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Check if the customer opted out of notifications', 'wootsap'); ?></li>
                    <li><?php echo esc_html__('Enable debug mode to see detailed logs', 'wootsap'); ?></li>
                </ul>
            </section>
            
            <section id="faq">
                <h2><?php echo esc_html__('Frequently Asked Questions', 'wootsap'); ?></h2>
                
                <div class="wootsap-faq-item">
                    <h4><?php echo esc_html__('Does the customer need a WhatsApp account?', 'wootsap'); ?></h4>
                    <p><?php echo esc_html__('Yes, the customer must have WhatsApp installed on their device to receive notifications.', 'wootsap'); ?></p>
                </div>
                
                <div class="wootsap-faq-item">
                    <h4><?php echo esc_html__('Can I send notifications to multiple numbers?', 'wootsap'); ?></h4>
                    <p><?php echo esc_html__('Currently, notifications are sent only to the customer\'s WhatsApp number or billing phone.', 'wootsap'); ?></p>
                </div>
                
                <div class="wootsap-faq-item">
                    <h4><?php echo esc_html__('Is there a limit to the number of notifications I can send?', 'wootsap'); ?></h4>
                    <p><?php echo esc_html__('Notification limits depend on your WooTsap subscription plan. Check your account for details or upgrade for higher limits.', 'wootsap'); ?></p>
                </div>
            </section>
        </div>
    </div>
</div>

<style>
/* Add custom CSS for the text logo */
.wootsap-text-logo {
    display: flex;
    align-items: baseline;
    margin-bottom: 15px;
}

.wootsap-logo-text {
    font-size: 32px;
    font-weight: bold;
    color: #00b044;
    margin-right: 10px;
}

.wootsap-logo-tagline {
    font-size: 16px;
    color: #555;
}

/* Enhance existing styles */
.wootsap-header {
    margin-bottom: 20px;
    border-bottom: 1px solid #eee;
    padding-bottom: 15px;
}

.wootsap-docs-container {
    display: flex;
    margin-top: 20px;
}

.wootsap-docs-sidebar {
    width: 25%;
    padding-right: 20px;
}

.wootsap-docs-content {
    width: 75%;
}

.wootsap-docs-sidebar ul {
    margin: 0;
    padding: 0;
    list-style: none;
}

.wootsap-docs-sidebar li {
    margin-bottom: 10px;
}

.wootsap-docs-sidebar a {
    text-decoration: none;
    display: block;
    padding: 8px;
    border-left: 3px solid transparent;
}

.wootsap-docs-sidebar a:hover,
.wootsap-docs-sidebar a:focus {
    border-left-color: #00b044;
    color: #00b044;
    background: #f9f9f9;
}

section {
    margin-bottom: 30px;
}

.wootsap-faq-item {
    margin-bottom: 20px;
}

.wootsap-faq-item h4 {
    margin-bottom: 5px;
    color: #333;
}
</style>