<?php
/**
 * Buy a Plan page template
 */

// If accessed directly, exit
if (!defined('ABSPATH')) {
    exit;
}
?>

<style>
    .wootsap-plans-container {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin: 20px 0;
    }
    
    .wootsap-plan {
        background-color: #fff;
        border-radius: 4px;
        padding: 20px;
        flex: 1;
        min-width: 280px;
        box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        display: flex;
        flex-direction: column;
    }
    
    .wootsap-plan-header {
        margin-bottom: 15px;
    }
    
    .wootsap-plan-header h2 {
        margin: 0 0 10px 0;
        font-size: 20px;
        color: #333;
    }
    
    .wootsap-original-price {
        display: block;
        color: #777;
        text-decoration: line-through;
        font-size: 14px;
    }
    
    .wootsap-price {
        font-size: 26px;
        font-weight: bold;
        color: #333;
        display: block;
        margin-bottom: 2px;
    }
    
    .wootsap-days {
        font-size: 14px;
        color: #555;
        display: block;
    }
    
    .wootsap-plan-features {
        margin-bottom: 20px;
        flex-grow: 1;
    }
    
    .wootsap-plan-features ul {
        list-style: none;
        margin: 0;
        padding: 0;
    }
    
    .wootsap-plan-features li {
        padding: 6px 0;
        font-size: 14px;
        display: flex;
        align-items: center;
    }
    
    .wootsap-plan-features li .dashicons {
        color: #4CAF50;
        margin-right: 8px;
    }
    
    .wootsap-plan-footer .button {
        width: 100%;
        text-align: center;
        padding: 8px 0;
        height: auto;
        background-color: #1E88E5;
        border-color: #1976D2;
    }
    
    .wootsap-plan-footer .button:hover {
        background-color: #1976D2;
        border-color: #1565C0;
    }
    
    .wootsap-plan-footer .dashicons {
        margin-right: 8px;
    }
    
    @media (max-width: 768px) {
        .wootsap-plans-container {
            flex-direction: column;
        }
        .wootsap-plan {
            width: 100%;
            margin-bottom: 10px;
        }
    }
</style>

<div class="wrap wootsap-buy-plan">
    <h1><?php echo esc_html__('WooTsap Plans', 'wootsap'); ?></h1>
    
    <div class="wootsap-plans-container">
        <!-- Starter Plan -->
        <div class="wootsap-plan">
            <div class="wootsap-plan-header">
                <h2><?php echo esc_html__('Starter Plan', 'wootsap'); ?></h2>
                <span class="wootsap-original-price">₹50</span>
                <span class="wootsap-price">0</span>
                <span class="wootsap-days">10 <?php echo esc_html__('Days', 'wootsap'); ?></span>
            </div>
            <div class="wootsap-plan-features">
                <ul>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Instances (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Warmer', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Phonebook limit (10)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat tags (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat notes (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chatbot', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('API Access', 'wootsap'); ?></li>
                </ul>
            </div>
            <div class="wootsap-plan-footer">
                <a href="https://api.wootsap.com/user/login" target="_blank" class="button button-primary">
                    <span class="dashicons dashicons-cart"></span>
                    <?php echo esc_html__('GET STARTED', 'wootsap'); ?>
                </a>
            </div>
        </div>
        
        <!-- Professional Plan -->
        <div class="wootsap-plan">
            <div class="wootsap-plan-header">
                <h2><?php echo esc_html__('Professional Plan', 'wootsap'); ?></h2>
                <span class="wootsap-original-price">₹599</span>
                <span class="wootsap-price">₹299</span>
                <span class="wootsap-days">30 <?php echo esc_html__('Days', 'wootsap'); ?></span>
            </div>
            <div class="wootsap-plan-features">
                <ul>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Instances (5)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Warmer', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Phonebook limit (500)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat tags (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat notes (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chatbot', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('API Access', 'wootsap'); ?></li>
                </ul>
            </div>
            <div class="wootsap-plan-footer">
                <a href="https://wootsap.com/whatsapp/" target="_blank" class="button button-primary">
                    <span class="dashicons dashicons-cart"></span>
                    <?php echo esc_html__('GET STARTED', 'wootsap'); ?>
                </a>
            </div>
        </div>
        
        <!-- Business Pro Plan -->
        <div class="wootsap-plan">
            <div class="wootsap-plan-header">
                <h2><?php echo esc_html__('Business Pro Plan', 'wootsap'); ?></h2>
                <span class="wootsap-original-price">₹799</span>
                <span class="wootsap-price">₹500</span>
                <span class="wootsap-days">30 <?php echo esc_html__('Days', 'wootsap'); ?></span>
            </div>
            <div class="wootsap-plan-features">
                <ul>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Instances (10)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('WhatsApp Warmer', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Phonebook limit (1000)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat tags (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chat notes (1)', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('Chatbot', 'wootsap'); ?></li>
                    <li><span class="dashicons dashicons-yes-alt"></span><?php echo esc_html__('API Access', 'wootsap'); ?></li>
                </ul>
            </div>
            <div class="wootsap-plan-footer">
                <a href="https://wootsap.com/whatsapp/" target="_blank" class="button button-primary">
                    <span class="dashicons dashicons-cart"></span>
                    <?php echo esc_html__('GET STARTED', 'wootsap'); ?>
                </a>
            </div>
        </div>
    </div>
</div>