/**
 * WooTsap Admin JavaScript
 */
(function($) {
    'use strict';
    
    // Document ready
    $(document).ready(function() {
        
        // Settings tabs
        $('.wootsap-tabs li a').on('click', function(e) {
            e.preventDefault();
            
            // Get target tab
            var targetTab = $(this).attr('href');
            
            // Remove active class from all tabs and content
            $('.wootsap-tabs li').removeClass('active');
            $('.wootsap-tab-content').removeClass('active');
            
            // Add active class to selected tab and content
            $(this).parent().addClass('active');
            $(targetTab).addClass('active');
        });
        
        // Test API button - Using multiple selectors to ensure we catch the button
        $(document).on('click', '#wootsap_test_api_btn, #wootsap-test-api, button:contains("Test Connection"), .button:contains("Test Connection")', function(e) {
            e.preventDefault();
            
            var button = $(this);
            var container = button.closest('td, div');
            var testPhone = $('#wootsap_test_phone').length ? $('#wootsap_test_phone').val() : $('input[placeholder*="WhatsApp number for testing"]').val();
            var resultDiv = $('#wootsap_test_result, #wootsap-test-result');
            var spinner = button.next('.spinner');
            
            console.log('Test button clicked');
            console.log('Phone value:', testPhone);
            
            // If result div doesn't exist, create it after the button
            if (resultDiv.length === 0) {
                button.after('<div id="wootsap_test_result" class="wootsap-test-result" style="margin-top: 10px;"></div>');
                resultDiv = $('#wootsap_test_result');
            }
            
            // Validate phone number
            if (!testPhone || testPhone.trim() === '') {
                resultDiv.html('<span class="wootsap-error" style="color: red;">❌ Please enter a phone number for testing.</span>');
                return;
            }
            
            // Disable button, add spinner if needed
            button.prop('disabled', true);
            if (spinner.length === 0) {
                button.after('<span class="spinner" style="visibility: visible; float: none; margin: 0 5px;"></span>');
                spinner = button.next('.spinner');
            }
            spinner.css('visibility', 'visible');
            resultDiv.html('<span class="wootsap-testing">Testing connection...</span>');
            
            // Send AJAX request
            $.ajax({
                url: ajaxurl || wootsap_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'wootsap_test_api',
                    security: wootsap_params.nonce,
                    test_phone: testPhone
                },
                success: function(response) {
                    console.log('AJAX response:', response);
                    if (response.success) {
                        resultDiv.html('<span class="wootsap-success" style="color: green;">✅ ' + response.data + '</span>');
                    } else {
                        resultDiv.html('<span class="wootsap-error" style="color: red;">❌ ' + response.data + '</span>');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', error);
                    resultDiv.html('<span class="wootsap-error" style="color: red;">❌ Connection error: ' + error + '</span>');
                },
                complete: function() {
                    button.prop('disabled', false);
                    spinner.css('visibility', 'hidden');
                }
            });
        });
        
        // Manual notification buttons
        $('.wootsap-send-manual').on('click', function() {
            var button = $(this);
            var type = button.data('type');
            var resultDiv = $('#wootsap-manual-result');
            
            // Disable button and show loading message
            button.prop('disabled', true);
            resultDiv.html('<p>Sending...</p>');
            
            // Send AJAX request
            $.ajax({
                url: ajaxurl || wootsap_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'wootsap_send_manual',
                    order_id: $('#wootsap-order-id').val(),
                    type: type,
                    security: $('#wootsap_manual_nonce').val()
                },
                success: function(response) {
                    button.prop('disabled', false);
                    
                    if (response.success) {
                        resultDiv.html('<p class="wootsap-success" style="color: green;">' + response.data + '</p>');
                    } else {
                        resultDiv.html('<p class="wootsap-error" style="color: red;">' + response.data + '</p>');
                    }
                },
                error: function() {
                    button.prop('disabled', false);
                    resultDiv.html('<p class="wootsap-error" style="color: red;">Connection error</p>');
                }
            });
        });
        
        // Documentation page smooth scrolling
        $('.wootsap-docs-sidebar a').on('click', function(e) {
            e.preventDefault();
            
            var target = $(this).attr('href');
            $('html, body').animate({
                scrollTop: $(target).offset().top - 50
            }, 500);
        });
    });
    
})(jQuery);